﻿<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Skrócona lista pracowników etatowych</title>
		<script runat="server">
            //
            // Informacje o zmianie warunków zatrudnienia
            // (c) SONETA Sp. z o.o.
            // ul. Gen. Józefa Kustronia 44A
            // 30-432 Kraków
            // mailto:info@enova.pl

            public class SrParams : SerializableContextBase {
                public SrParams(Context context) : base(context) {
                }

                bool pelneStanowisko = false;
                [Priority(1)]
                [Caption("Stanowisko pełna nazwa")]
                public bool PelneStanowisko {
                    get { return pelneStanowisko; }
                    set {
                        pelneStanowisko = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }

            SrParams srpars;
            [SettingsContext]
            public SrParams SrPars {
                get { return srpars; }
                set { srpars = value; }
            }		
            
		    //Filtrowanie zdarzeń. Można wybrać dowolne zdarzenia z typu TypZdarzenia
            //wpisanie wartości= (TypZdarzenia)0xFFFF; oznacza wszyskit zdarzenia
		    //Dla wybriania poszczególnych zdarzeń wpisujemy jak poniżej oddzielając znakiem |:
            // = TypZdarzenia.UmowaOPracę|TypZdarzenia.RozwiązanieUmowy;
            TypZdarzenia filtrZdarzeń = (TypZdarzenia)0xFFFF;
		
		    //Sposób prezentowania wydruku. Można wybrać grupowanie WgDaty, WgPracownika lub wydruk
            //płaski (Brak);
            Grupowanie grupowanie = Grupowanie.WgPracownika;
		    
            enum Grupowanie {
                Brak,
                WgPracownika,
                WgDaty,
            }		        
		        
            [Flags]
            enum TypZdarzenia {
                UmowaOPracę = 0x01,
                PrzedłużenieUmowy = 0x02,
                ZmianaWarunków = 0x04,
                RozwiązanieUmowy = 0x08,
            }
		        
            class Zdarzenie {

                readonly Pracownik pracownik;
                readonly Date data;
                readonly TypZdarzenia typ;
                readonly string[] uwagi;

                public Zdarzenie(Pracownik pracownik, Date data, TypZdarzenia typ, params string[] uwagi) {
                    this.pracownik = pracownik;
                    this.data = data;
                    this.typ = typ;
                    this.uwagi = uwagi;
                }

                public Pracownik Pracownik {
                    get { return pracownik; }
                }

                public Date Data {
                    get { return data; }
                }

                public TypZdarzenia Typ {
                    get { return typ; }
                }

                public string[] Uwagi {
                    get { return uwagi; }
                }
            }

            class DataPracownikComparer : IComparer<Zdarzenie> {

                public int Compare(Zdarzenie x, Zdarzenie y) {
                    int result = x.Data.CompareTo(y.Data);
                    if (result == 0)
                        result = x.Pracownik.NazwiskoImię.CompareTo(y.Pracownik.NazwiskoImię);
                    if (result == 0)
                        result = x.Pracownik.Kod.CompareTo(y.Pracownik.Kod);
                    return result;
                }
            }
		        
            void OnContextLoad(Object sender, EventArgs args) {
                Row[] rows = (Row[])dc[typeof(Row[])];
                FromTo okres = ((Soneta.Kadry.Forms.StdParams)dc[typeof(Soneta.Kadry.Forms.StdParams)]).Okres;

                ReportHeader1["OKRES"] = okres.ToString();

                List<Zdarzenie> zdarzenia = new List<Zdarzenie>();
                Log log = new Log();
                foreach (Pracownik idx in rows) {
                    log.WriteLine(idx);
                    DodajZdarzenia(idx, zdarzenia);
                }

                List<Zdarzenie> z2 = new List<Zdarzenie>();
                foreach (Zdarzenie z in zdarzenia)
                    if (okres.Contains(z.Data) && (filtrZdarzeń&z.Typ)!=0)
                        z2.Add(z);

                switch (grupowanie) {
                    case Grupowanie.WgDaty:
                        colData.Visible = false;
                        colUwagi.Width += colData.Width;
                        Grid1.GroupData0 = colData.DataMember;
                        Grid1.GroupLine = "{0}";
                        z2.Sort(new DataPracownikComparer());
                        break;                        
                        
                    case Grupowanie.WgPracownika:
                        colPracownik.Visible = false;
                        colKod.Visible = false;
                        colUwagi.Width = 0;
                        Grid1.GroupData0 = colPracownik.DataMember;
                        Grid1.GroupData1 = colKod.DataMember;
                        Grid1.GroupLine = "{0} ({1})";
                        break;                                        
                }
                
                Grid1.DataSource = z2;
            }

            void DodajZdarzenia(Pracownik pracownik, List<Zdarzenie> zdarzenia) {
                PracHistoria prev = null;
                foreach (PracHistoria ph in pracownik.Historia) {
                    FromTo efektywny = ph.Etat.EfektywnyOkres;
                    if (ph.Etat.EfektywnyOkres != FromTo.Empty) {
                        if (ph.Aktualnosc.Contains(ph.Etat.Okres.From))
                            if (ph.Etat.Okres.From == ph.Aktualnosc.From && prev != null && prev.Etat.Okres.To == ph.Etat.Okres.From - 1)
                                zdarzenia.Add(new Zdarzenie(pracownik, ph.Etat.Okres.From, TypZdarzenia.PrzedłużenieUmowy,
                                    !ZmianaTypu(prev, ph) ? "" : "typ umowy: " + CaptionAttribute.EnumToString(ph.Etat.TypUmowy),
                                    !ZmianaWymiaru(prev, ph) ? "" : "wymiar: " + ph.Etat.Zaszeregowanie.Wymiar,
                                    !ZmianaStanowiska(prev, ph) ? "" : "stanowisko: " + GetStanowisko(ph),
                                    !ZmianaStawki(prev, ph) ? "" : "stawka: " + ph.Etat.Zaszeregowanie.Stawka + (ph.Etat.Zaszeregowanie.RodzajStawki == RodzajStawkiZaszeregowania.Godzinowa ? "/godz" : "/mies")));
                            else
                                zdarzenia.Add(new Zdarzenie(pracownik, ph.Etat.Okres.From, TypZdarzenia.UmowaOPracę,
                                    "typ umowy: " + CaptionAttribute.EnumToString(ph.Etat.TypUmowy),
                                    "wymiar: " + ph.Etat.Zaszeregowanie.Wymiar,
                                    "stanowisko: " + GetStanowisko(ph),
                                    "stawka: " + ph.Etat.Zaszeregowanie.Stawka + (ph.Etat.Zaszeregowanie.RodzajStawki == RodzajStawkiZaszeregowania.Godzinowa ? "/godz" : "/mies")));
                        else if (prev != null && (ZmianaTypu(prev, ph) || ZmianaWymiaru(prev, ph) || ZmianaStanowiska(prev, ph) || ZmianaStawki(prev, ph)))
                            zdarzenia.Add(new Zdarzenie(pracownik, ph.Aktualnosc.From, TypZdarzenia.ZmianaWarunków,
                                !ZmianaTypu(prev, ph) ? "" : "typ umowy: " + CaptionAttribute.EnumToString(ph.Etat.TypUmowy),
                                !ZmianaWymiaru(prev, ph) ? "" : "wymiar: " + ph.Etat.Zaszeregowanie.Wymiar,
                                !ZmianaStanowiska(prev, ph) ? "" : "stanowisko: " + GetStanowisko(ph),
                                !ZmianaStawki(prev, ph) ? "" : "stawka: " + ph.Etat.Zaszeregowanie.Stawka + (ph.Etat.Zaszeregowanie.RodzajStawki == RodzajStawkiZaszeregowania.Godzinowa ? "/godz" : "/mies")));

                        if (ph.Etat.Okres.To<Date.MaxValue && ph.Etat.Okres.To <= ph.Aktualnosc.To)
                            zdarzenia.Add(new Zdarzenie(pracownik, ph.Etat.Okres.To, TypZdarzenia.RozwiązanieUmowy,
                                "przyczyna: " + ph.Etat.PrzyczynaRozwUmowy));

                        prev = ph;
                    }
                    else
                        prev = null;
                }
            }

            string GetStanowisko(PracHistoria ph) {
                string stanowiskoPelne = "";
                if (srpars.PelneStanowisko)
                    stanowiskoPelne = ph.Etat.StanowiskoPełne;
                if (stanowiskoPelne.Length == 0)
                    stanowiskoPelne = ph.Etat.Stanowisko;
                return stanowiskoPelne;
            }

            bool ZmianaTypu(PracHistoria prev, PracHistoria ph) {
                return prev.Etat.TypUmowy != ph.Etat.TypUmowy;
            }

            bool ZmianaWymiaru(PracHistoria prev, PracHistoria ph) {
                return prev.Etat.Zaszeregowanie.Wymiar != ph.Etat.Zaszeregowanie.Wymiar;
            }

            bool ZmianaStanowiska(PracHistoria prev, PracHistoria ph) {
                return GetStanowisko(prev).Trim().ToUpper() != GetStanowisko(ph).Trim().ToUpper();
            }

            bool ZmianaStawki(PracHistoria prev, PracHistoria ph) {
                return prev.Etat.Zaszeregowanie.Stawka.Symbol != ph.Etat.Zaszeregowanie.Stawka.Symbol || prev.Etat.Zaszeregowanie.Stawka.Value != ph.Etat.Zaszeregowanie.Stawka.Value || prev.Etat.Zaszeregowanie.RodzajStawki != ph.Etat.Zaszeregowanie.RodzajStawki;
            }

            protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
                Zdarzenie zdarzenie = (Zdarzenie)args.Row;

                foreach (string s in zdarzenie.Uwagi)
                    if (s != "")
                        colUwagi.AddLine(s);
            }

            static void Msg(object value) {
            }
</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="PracListaSkrócona" method="post" runat="server">
			<EA:DATACONTEXT id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Business.Row[], Soneta.Business"></EA:DATACONTEXT>
			<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Historia zmian warunków zatrudnienia|</strong>Za okres: <strong>%OKRES%" runat="server"></cc1:reportheader>
			<EA:GRID id="Grid1" runat="server" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" OnBeforeRow="Grid1_BeforeRow">
				<Columns>
					<ea:GridColumn Caption="LP." DataMember="#" Align="Right" Width="4" runat="server"></ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Pracownik~Nazwisko i imię" DataMember="Pracownik.NazwiskoImię" ID="colPracownik">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Pracownik~kod" DataMember="Pracownik.Kod"
                        Width="10" ID="colKod">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" NoWrap="True" Width="16" Caption="Zdarzenie~Typ" DataMember="Typ" Align="Center">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="10" Caption="Zdarzenie~Data" DataMember="Data" Align="Center" ID="colData">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="40" Caption="Zdarzenie~Uwagi" ID="colUwagi">
                    </ea:GridColumn>
				</Columns>
			</EA:GRID>
			<cc1:reportfooter id="ReportFooter1" runat="server"></cc1:reportfooter>
		</form>
	</body>
</HTML>
